from pprint import pprint

# načtení názvů států ze souboru s plochami
plochy = {} # slovník
with open('staty_plochy.log') as soubor:
    for řádka in soubor:
        stát, plocha = řádka.rstrip('\n').split(': ')
        plochy[stát] = plocha   # pod klíčem stát bude jeho plocha

# načtení názvů států ze souboru s počtem obyvatel
lidi = {}   # slovník
with open('staty_lidi.log') as soubor:
    for řádka in soubor:
        stát, počet_obyvatel = řádka.rstrip('\n').split(': ')
        lidi[stát] = počet_obyvatel # pod klíčem stát bude jeho počet obyvatel

# slovník hustoty zalidnění klíčovaný názvem státu
státy = {}

# počtů obyvatel je méně a všechny jejich státy jsou i v plochách, ale opačně to není pravda -- ploch je o 24 více než lidí
for stát in plochy:
    # pro 24 států neexistuje záznam o počtu obyvatel, ale metoda get() se o to postará a vrátí pro ně 0
    počet_obyvatel = lidi.get(stát, 0)
    # záznam pro plochy existuje pro všechny státy
    plocha = plochy[stát]
    státy[stát] = (
        plocha,
        počet_obyvatel,
        int(počet_obyvatel) / float(plocha)
    )
    # PS: int(0) = 0 takže nevadí, že get() vrací rovnou číslo

# výpis států seřazený podle hustoty zalidnění
def řadicí_funkce(x):
    # x je klíč do slovníku států, takže je to název státu
    print('-->', x)
    # státy[x] je trojce údajů o příslušném státu =>
    # => státy[x][-1] je poslední údaj o státu, což je hustota
    return státy[x][-1]

for stát in sorted(státy, key=řadicí_funkce):
    print(stát, státy[stát])
